/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsbc.dimensions.level;

import com.google.common.collect.ImmutableMap;
import dev.ftb.ftbsbc.dimensions.level.ArchivedDimension;
import dev.ftb.mods.ftbteams.data.Team;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.TriConsumer;

public class DimensionStorage
extends SavedData {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String SAVE_NAME = new ResourceLocation("ftbsbc", "dimension_store").toString().replace(":", "_");
    private final HashMap<UUID, ResourceLocation> teamToDimension = new HashMap();
    private final HashMap<ResourceLocation, BlockPos> dimensionSpawnLocations = new HashMap();
    private final List<ArchivedDimension> archivedDimensions = new ArrayList<ArchivedDimension>();
    private boolean lobbySpawned = false;
    private BlockPos lobbySpawnPos = BlockPos.f_121853_;

    @Nullable
    public static DimensionStorage get() {
        ServerLevel level = ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_);
        if (level == null) {
            return null;
        }
        DimensionDataStorage dataStorage = level.m_8895_();
        DimensionStorage.fixWrongNameIssue(dataStorage);
        return (DimensionStorage)dataStorage.m_164861_(DimensionStorage::load, DimensionStorage::new, SAVE_NAME);
    }

    public static DimensionStorage get(MinecraftServer server) {
        DimensionDataStorage dataStorage = server.m_129880_(Level.f_46428_).m_8895_();
        DimensionStorage.fixWrongNameIssue(dataStorage);
        return (DimensionStorage)dataStorage.m_164861_(DimensionStorage::load, DimensionStorage::new, SAVE_NAME);
    }

    private static void fixWrongNameIssue(DimensionDataStorage dataStorage) {
        String oldName = new ResourceLocation("ftbsbc", "dimension_store").toString();
        File dataFile = dataStorage.m_78156_(oldName);
        if (dataFile.exists()) {
            try (FileInputStream fileInput = new FileInputStream(dataFile);){
                byte[] bytes = fileInput.readAllBytes();
                File newDataFile = dataStorage.m_78156_(SAVE_NAME);
                Files.write(newDataFile.toPath(), bytes, new OpenOption[0]);
                boolean bl = dataFile.delete();
            }
            catch (IOException e) {
                LOGGER.error("Failed to migrate data to new file", (Throwable)e);
            }
        }
    }

    @Nullable
    public ResourceKey<Level> getDimensionId(Team team) {
        ResourceLocation dimLocation = this.teamToDimension.get(team.getId());
        if (dimLocation == null) {
            return null;
        }
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimLocation);
    }

    public ResourceKey<Level> putDimension(Team playerTeam, String generateDimensionName) {
        return this.putDimension(playerTeam, new ResourceLocation("ftbsbc", "team/%s".formatted(generateDimensionName)));
    }

    public ResourceKey<Level> putDimension(Team playerTeam, ResourceLocation generateDimensionName) {
        this.teamToDimension.put(playerTeam.getId(), generateDimensionName);
        this.m_77762_();
        return this.getDimensionId(playerTeam);
    }

    public void archiveDimension(Team oldTeam) {
        ResourceKey<Level> dimensionId = this.getDimensionId(oldTeam);
        if (dimensionId == null) {
            return;
        }
        this.teamToDimension.remove(oldTeam.getId());
        String playerName = "unknown";
        ServerPlayer player = oldTeam.manager.server.m_6846_().m_11259_(oldTeam.getOwner());
        if (player != null) {
            playerName = player.m_5446_().getString();
        }
        this.archivedDimensions.add(new ArchivedDimension(playerName, oldTeam.getOwner(), oldTeam.getDisplayName(), dimensionId.m_135782_()));
        this.m_77762_();
    }

    public List<ArchivedDimension> getArchivedDimensions() {
        return this.archivedDimensions;
    }

    public Optional<ArchivedDimension> getArchivedDimension(ResourceLocation location) {
        return this.archivedDimensions.stream().filter(e -> e.dimensionName().equals((Object)location)).findFirst();
    }

    public ImmutableMap<UUID, ResourceLocation> getTeamToDimension() {
        return ImmutableMap.copyOf(this.teamToDimension);
    }

    @Nullable
    public BlockPos getDimensionSpawnLocations(ResourceLocation dimKeyLocation) {
        return this.dimensionSpawnLocations.get(dimKeyLocation);
    }

    public void addDimensionSpawn(ResourceLocation location, BlockPos pos) {
        this.dimensionSpawnLocations.put(location, pos);
        this.m_77762_();
    }

    public boolean isLobbySpawned() {
        return this.lobbySpawned;
    }

    public void setLobbySpawned(boolean lobbySpawned) {
        this.lobbySpawned = lobbySpawned;
        this.m_77762_();
    }

    public BlockPos getLobbySpawnPos() {
        return this.lobbySpawnPos;
    }

    public void setLobbySpawnPos(BlockPos lobbySpawnPos) {
        this.lobbySpawnPos = lobbySpawnPos;
        this.m_77762_();
    }

    private static DimensionStorage load(CompoundTag compoundTag) {
        DimensionStorage storage = new DimensionStorage();
        storage.read(compoundTag);
        return storage;
    }

    private void read(CompoundTag tag) {
        if (!tag.m_128441_("team_dimensions")) {
            return;
        }
        this.teamToDimension.putAll(this.hashMapReader(UUID::fromString, (tag1, key) -> new ResourceLocation(tag1.m_128461_(key)), tag.m_128469_("team_dimensions")));
        this.dimensionSpawnLocations.putAll(this.hashMapReader(ResourceLocation::new, (tag1, key) -> BlockPos.m_122022_((long)tag1.m_128454_(key)), tag.m_128469_("dimension_spawns")));
        ListTag dimensionsArchive = tag.m_128437_("dimensions_archive", 10);
        for (int i = 0; i < dimensionsArchive.size(); ++i) {
            this.archivedDimensions.add(ArchivedDimension.read(dimensionsArchive.m_128728_(i)));
        }
        this.lobbySpawned = tag.m_128471_("lobby_spawned");
        if (tag.m_128441_("lobby_spawn_pos")) {
            this.lobbySpawnPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("lobby_spawn_pos"));
        }
    }

    public CompoundTag m_7176_(CompoundTag arg) {
        arg.m_128365_("team_dimensions", (Tag)this.hashMapWriter(this.teamToDimension, (tag, key, value) -> tag.m_128359_(key.toString(), value.toString())));
        arg.m_128365_("dimension_spawns", (Tag)this.hashMapWriter(this.dimensionSpawnLocations, (tag, key, value) -> tag.m_128356_(key.toString(), value.m_121878_())));
        ListTag archivedList = new ListTag();
        this.archivedDimensions.forEach(e -> archivedList.add((Object)e.write()));
        arg.m_128365_("dimensions_archive", (Tag)archivedList);
        arg.m_128379_("lobby_spawned", this.lobbySpawned);
        arg.m_128365_("lobby_spawn_pos", (Tag)NbtUtils.m_129224_((BlockPos)this.lobbySpawnPos));
        this.m_77760_(false);
        return arg;
    }

    private <K, V> HashMap<K, V> hashMapReader(Function<String, K> keyReader, BiFunction<CompoundTag, String, V> valueReader, CompoundTag tag) {
        HashMap<K, V> hashMap = new HashMap<K, V>();
        for (String key : tag.m_128431_()) {
            hashMap.put(keyReader.apply(key), valueReader.apply(tag, key));
        }
        return hashMap;
    }

    private <K, V> CompoundTag hashMapWriter(HashMap<K, V> map, TriConsumer<CompoundTag, K, V> writer) {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<K, V> kvEntry : map.entrySet()) {
            writer.accept((Object)tag, kvEntry.getKey(), kvEntry.getValue());
        }
        return tag;
    }
}

